/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities;

import java.util.List;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.gamecontext.Updatable;

public class EntityUpdater
implements GameContextAware,
Updatable {
    private int infrequentUpdateCursor = 0;
    private final float TIME_BETWEEN_INFREQUENT_UPDATE_SECONDS = 3.0f;
    private GameContext gameContext;

    @Override
    public void update(float deltaTime) {
        if (this.gameContext != null) {
            for (Entity updatableEntity : this.gameContext.getEntityStore().getUpdateEveryFrameEntities()) {
                if (updatableEntity == null) continue;
                updatableEntity.update(deltaTime, this.gameContext.getAreaMap());
            }
            List<Entity> infrequentUpdateEntities = this.gameContext.getEntityStore().getUpdateInfrequentlyEntities();
            float numInfrequentEntitiesToUpdatePerSecond = (float)infrequentUpdateEntities.size() / 3.0f;
            int numEntitiesToUpdateThisFrame = Math.round(deltaTime * numInfrequentEntitiesToUpdatePerSecond);
            if (!infrequentUpdateEntities.isEmpty()) {
                for (numEntitiesToUpdateThisFrame = Math.max(1, numEntitiesToUpdateThisFrame); numEntitiesToUpdateThisFrame > 0; --numEntitiesToUpdateThisFrame) {
                    if (this.infrequentUpdateCursor >= infrequentUpdateEntities.size()) {
                        this.infrequentUpdateCursor = 0;
                    }
                    Entity entity = infrequentUpdateEntities.get(this.infrequentUpdateCursor);
                    entity.infrequentUpdate(this.gameContext);
                    this.incrementCursor(infrequentUpdateEntities.size());
                }
            }
        }
    }

    private void incrementCursor(int max) {
        ++this.infrequentUpdateCursor;
        if (this.infrequentUpdateCursor >= max) {
            this.infrequentUpdateCursor = 0;
        }
    }

    @Override
    public boolean runWhilePaused() {
        return false;
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.infrequentUpdateCursor = 0;
        this.gameContext = gameContext;
    }
}

